// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 13, Aufgabe 2
// "Erweiterung von Stack"

//---------------------------------------------------
// class Stack
//---------------------------------------------------
class Stack {
	protected int[] val;
	protected int top;
	protected int size;
	
	Stack(int size) {
		this.size = size;
		val = new int[size];
		top = 0;
	}
	
	void push(int x) {
		if (top < size)
			val[top++] = x;
		else
			Out.println("-- stack overflow");
	}
	
	int pop() {
		if (top > 0)
			return val[--top];
		else {
			Out.println("-- stack underflow");
			return 0;
		}
	}
}

//---------------------------------------------------
// class GrowableStack
//---------------------------------------------------
class GrowableStack extends Stack {
	
	GrowableStack(int size) { super(size); }
	
	void push(int x) {
		if (top >= size) {
			size = 2 * size;
			int[] v = new int[size];
			for (int i = 0; i < top; i++) v[i] = val[i];
			val = v;
		}
		super.push(x);
	}
	
	int size() {
		return top;
	}
}

//---------------------------------------------------
// Test program
//---------------------------------------------------
public class A2 {
	
	public static void main(String args[]) {
		GrowableStack s = new GrowableStack(3);
		s.push(1);
		s.push(2);
		s.push(3);
		Out.println("size = " + s.size());
		s.push(4);
		s.push(5);
		s.push(6);
		Out.println("size = " + s.size());
		s.push(7);
		Out.println("size = " + s.size());
		for (int i = s.size(); i > 0; i--)
			Out.print(s.pop() + " ");
	}
}
